/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import net.minecraft.init.SoundEvents;

public class GuiAnalogeSlider
extends GuiControl {
    public double maxValue;
    public double minValue;
    public double value;
    public boolean grabbedSlider;
    public int sliderWidth = 4;
    protected GuiTextfield textfield = null;

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, double value, double minValue, double maxValue) {
        super(name, x, y, width, height);
        this.marginWidth = 0;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.setValue(value);
    }

    public String getTextByValue() {
        return (float)Math.round(this.value * 100.0) / 100.0f + "";
    }

    public String getTextfieldValue() {
        return this.getTextByValue();
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        double percent = this.getPercentage();
        int posX = (int)((double)(this.width - (this.borderWidth * 2 + this.sliderWidth)) * percent);
        style.getFace(this).renderStyle(posX, 0, helper, 4, height);
        if (this.textfield != null) {
            this.textfield.renderControl(helper, 1.0f, this.getRect());
        } else {
            helper.drawStringWithShadow(this.getTextByValue(), width, height, -1);
        }
    }

    public double getPercentage() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public boolean mousePressed(int x, int y, int button) {
        if (button == 0) {
            if (this.textfield != null) {
                return this.textfield.mousePressed(x, y, button);
            }
            GuiAnalogeSlider.playSound(SoundEvents.field_187909_gi);
            this.grabbedSlider = true;
            return true;
        }
        if (button == 1) {
            this.grabbedSlider = false;
            this.textfield = this.createTextfield();
            this.textfield.focused = true;
            this.textfield.setCursorPosition(this.textfield.text.length());
            this.textfield.parent = this.parent;
            return true;
        }
        return false;
    }

    protected GuiTextfield createTextfield() {
        return new GuiTextfield(this.getTextfieldValue(), 0, 0, this.width - this.getContentOffset() * 8, this.height - this.getContentOffset() * 8).setFloatOnly();
    }

    public void closeTextField() {
        double value = this.value;
        try {
            this.setValue(Float.parseFloat(this.textfield.text));
            GuiAnalogeSlider.playSound(SoundEvents.field_187909_gi);
        }
        catch (NumberFormatException e) {
            this.setValue(value);
        }
        this.textfield = null;
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (this.textfield != null) {
            if (key == 28) {
                this.closeTextField();
                return true;
            }
            return this.textfield.onKeyPressed(character, key);
        }
        return super.onKeyPressed(character, key);
    }

    public void setValue(double value) {
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            int width = this.width - this.getContentOffset() * 2 - this.sliderWidth;
            if (posX < this.posX + this.getContentOffset()) {
                this.value = this.minValue;
            } else if (posX > this.posX + this.getContentOffset() + width + this.sliderWidth / 2) {
                this.value = this.maxValue;
            } else {
                int mouseOffsetX = posX - this.posX - this.getContentOffset() - this.sliderWidth / 2;
                this.value = (float)(this.minValue + (double)((float)((this.maxValue - this.minValue) * (double)((float)mouseOffsetX / (float)width))));
            }
            this.setValue(this.value);
        }
    }

    @Override
    public void onLoseFocus() {
        if (this.textfield != null) {
            this.closeTextField();
        }
        super.onLoseFocus();
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }
}

